#include <windows.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

static int GPLIsRunning()
{
    return FindWindow("PapyWin", "Papyrus Window") != NULL;
}

static void launchGPLAndWaitForItToFinish()
{
    system(".\\gpl.exe");

    Sleep(5000);
    while (GPLIsRunning()) {
        Sleep(2000);
    }
}

int main(
    int         argc,
    char        *argv[])
{
    char *usage = "Usage: gplicq [CLIENT ip first_name last_name | SERVER]\n";

    if (argc > 1) {
        if (!stricmp(argv[1], "CLIENT")) {

            // If the client already has an address book, save it.
            FILE *addrBook, *f;
            if ((addrBook = fopen("address.ini", "r")) != NULL) {
                fclose(addrBook);
                if ((f = fopen("address.bup", "r")) != NULL) {
                    fclose(f);
                    remove("address.bup");
                }
                rename("address.ini", "address.bup");
            }

            // Now, write a new address book, if specified on command line.
            if (argc > 2 &&
                (f = fopen("address.ini", "w")) != NULL) {

                fprintf(f, "[ entry0 ]\n");
                fprintf(f, "address = %s\n", argv[2]);
                if (argc > 3) {
                    fprintf(f, "name = %s %s\n", argv[3],
                                                 argc > 4 ? argv[4] : "");
                }
                fprintf(f, "type = 1\n");   // Assuming IP.
                fclose(f);
            }

            launchGPLAndWaitForItToFinish();

            // If we made an address.ini, remove it and restore original
            if (argc > 2) {
                remove("address.ini");
                if (addrBook) {
                    rename("address.bup", "address.ini");
                }
            }
        }
        else if (!stricmp(argv[1], "SERVER")) {
            if (!GPLIsRunning()) {
                launchGPLAndWaitForItToFinish();
            }
        }
        else {
            printf(usage);
            return 2;
        }
    }
    else {
        printf(usage);
        return 1;
    }
}

